/************
 * Load libraries 
 *************/
IGN.lib ={
	SCRIPTS_ROOT : 'http://scripts.ign.com/scripts/ign/',
	JSLIB_ROOT : 'http://scripts.ign.com/scripts/ign/lib/',
	PLUGIN_ROOT : 'http://scripts.ign.com/scripts/ign/plugins/',
	_jArr : [],
	_pArr : [],
	loadjs : function(j,p){
		if ($j.inArray(j, this._jArr) == -1) {			
			$j.getScript(this.JSLIB_ROOT + j + '.js', function(){				
				IGN.lib._jArr.push(j)
				IGN[j].init(p)
			})		  		  
		}else {
			IGN[j].init(p)
		}
	},
	loadplugin : function(p,cb){
		if ($j.inArray(p, this._pArr) == -1){
			$j.getScript(this.PLUGIN_ROOT + p + '.js', function(){
				IGN.lib._pArr.push(p)
				cb()
			})
		}else{
			cb()
		}		
	}
};
/************
 * Load pagetype specific JS, if necessary 
 *************/
switch(IGN.pagetype){
	case 'channel':
	case 'channel_video':
		$j.getScript(IGN.lib.SCRIPTS_ROOT +'pagetype/channel.js')
		break;
	case 'mediavideolist':
		$j.getScript(IGN.lib.SCRIPTS_ROOT +'pagetype/mediavideolist.js')
		break;
}

/************
 * Load these right away
 *************/
	$j.getScript(IGN.lib.PLUGIN_ROOT + 'jquery.elementReady.js', function(){
		IGN.lib.loadjs('headernav');
	})
	$j.getScript('http://scripts.ign.com/scripts/ign/utilities.js')
/************
 * Basic JS Utilities
 *************/
IGN.util = {
	searchCheatsFormSubmit: function(form){
		var subdomain = document.location.href;
		qry = urlEncode(form.query.value);
		if (qry == "") {
			alert('Please type in your search query.');
			return;
		} // check for empty strings 
		redir = "";
		if (form.domain[0].checked) { // cheats
			redir = "http://search.ign.com/articles?genNav=true&typeName=33&query=" + qry;
		}
		else 
			if (form.domain[1].checked) { // guides
				redir = "http://search.ign.com/articles?genNav=true&typeName=29&query=" + qry;
			}
			else 
				if (form.domain[2].checked) { // faqs
					redir = "http://search.ign.com/articles?genNav=true&typeName=31&query=" + qry;
				}
		gotoval = redir;
		if (gotoval != "") {
			document.location = gotoval;
		}
		return;
	},
	validatePlatformForm: function(form){
		if (form.morePlatformsSelect.value == '') {
			alert("Please select a platform.");
		}
		else {
			document.location = form.morePlatformsSelect.value
		}
	},
	snipIt: function(str, count){
		if (str == null) {
			return null
		}
		str = $j.trim(str)
		if (str.length < count) {
			return str;
		}
		
		return str.slice(0, count) + '...';
		
	},
	cleanText: function(str){
		if (str != null) {
			str = str.replace(/\é/g, "&#233;");
			str = str.replace(/\’/g, "&#39;");
			str = str.replace(/\“/g, "&#34;");
			str = str.replace(/\?/g, "&#34;");
			str = str.replace(/\…/g, "...");
			str = str.replace(/<[^<|>]+?>/gi, '');
			return str;
		}
		else {
			return null;
		}
	}
}
	
/********************
 * Locale implementation**
 *********************/	
IGN.locale ={
	init: function(loc){
		switch(loc){
			case 'uk':
			 IGN.locale.initUK();
			 break;
			case 'au':
			 IGN.locale.initAU()
			 break;
			default:
			 return
		}
	},	
	initUK : function(){
		$j('#mast_logo_flag').html('<img src="http://media.ign.com/ign/imgs/logo_flag_uk.png"/>').show();
		$j('#join_img').attr('src', 'http://media.ign.com/ign/imgs/bg_hub_insider_join_noprice.gif' );
	},	
	initAU : function(){
		$j('#mast_logo_flag').html('<img src="http://media.ign.com/ign/imgs/logo_flag_au.png"/>').show();
		$j('#join_img').attr('src', 'http://media.ign.com/ign/imgs/bg_hub_insider_join_noprice.gif' );
	}
} 
/********
 * Omniture Class
 *********/
IGN.omni ={
	omniTrackLink : function(sectionName, linkName) {
	    var s=s_gi(s_account);
	    s.linkTrackVars='prop15,eVar15';
	    s.prop15=s.eVar15=linkName;
	    s.tl(this, 'o', sectionName);
	}	
}
/********
* Image loader
*********/

IGN.ImageLoader={

		delayByView : function(imgId, imgSrc){
			var foldGroup = new YAHOO.util.ImageLoader.group(window, 'scroll', 10);
			foldGroup.foldConditional = true;
			foldGroup.registerSrcImage(imgId, imgSrc); 
			foldGroup.addTrigger(window, 'resize', 10); 
		},
		
		delayByEvent : function(params){
			var id=params[0];
			var arrObj=params[1];
			var event=params[2];
			var time=params[3];
			var objGroup=id+"_obj";
			if(arrObj.length >0){
		 		objGroup = new YAHOO.util.ImageLoader.group(id,event,time);
					for(i=0;i<arrObj.length;i++){
						objGroup.registerSrcImage(arrObj[i]["id"], arrObj[i]["src"]);
					}
			}
		}
}

$j(document).ready(function(){
	
/*************
 * Omniture Events * 
 ************/
	$j('a[omni_link]').click(function(e) {		    
	    IGN.omni.omniTrackLink($j(this).parents('div[omni_section]').attr('omni_section'), $j(this).attr('omni_link'));
	});
	
/*********************
 *** Initialize localization***
 **********************/
    IGN.locale.init(getLocale()); 
	
/********************
 * Global Tab events**
 *********************/
  if ( !checkLocale('uk') && !checkLocale('au')) {
 $j('#colRightProductsGameFly').show();
} else {
	$j('#colRightProductsGameFly').hide();
	if (($j('#colRightProductsD2DMobile') && $j('#colRightProductsD2DGuide') && $j('#colRightProductsAllPosters')).length == 0){
		$j('#colRightProducts').hide();
	}

}
 
  $j('ul.tabs').each(function(i,tab){  	
	 $j(tab).children('li:last').addClass('last');
	 if($j(tab).children('li').length == 1){
	  	 $j(tab).addClass('last_selected');
	  }
  })
  $j('ul.tabs').click(function(e){
		var target = $j(e.target)
		if (target.is('a')){
			target = target.parent()
		}
		var tab_divs = $j(this).attr('id').slice(0,-4)
		if (target.is('li') && !target.hasClass('tab_selected')){
			$j(this).children('li').removeClass('tab_selected').addClass('tab_default')
			target.removeClass('tab_default').addClass('tab_selected')				
			if (target.hasClass('last')){
				$j(this).addClass('last_selected')
			}else{
				$j(this).removeClass('last_selected')
			}
			var id = target.attr('id').slice(0,-3)
			$j('#'+tab_divs+'divs').children('div').hide()
			$j('#' +id+'div').show()				
		}			
	})
	
	$j('ul.tabs li').hover(function(e){
		if (!$j(e.target).hasClass('tab_selected')){
			$j(this).addClass('hover')
		}
	},function(e){
		if (!$j(e.target).hasClass('tab_selected')){
			$j(this).removeClass('hover')
		}
	})
	
 /*********************
 *** IE PNG fix for IE6**
 **********************/
/*
  if ($j.browser.msie && $j.browser.version <7){	  
	  $j.getScript(IGN.lib.PLUGIN_ROOT +'jquery.pngFix.js',function(){
	  	$j(document).pngFix();
	  })	
  }
  */
      
 /*********************
 *** Masthead events***
 **********************/
  $j('#mast_logo').click(function(){
  	document.location = 'http://www.ign.com';
  });
  $j('#mast_logo').hover(function(){
  		$j(this).addClass('hover');
	},function(){
		$j(this).removeClass('hover');
  });

  $j('.tab_filters a').click(function() {
	var my_parent = ($j(this).parent().parent()).attr('id');
	$j('#'+my_parent+' div.tab_filters a').removeClass('selected');
	$j(this).addClass('selected');
	var filter = $j(this).attr('id').slice(7);
	$j('#'+my_parent+' .item_list').hide();
	$j('#'+my_parent+' .list_column_all_link').hide();
	$j('#'+my_parent+' .item_' + filter).show();
});

$j('#more_platforms').change(function() { 
	var link_loc = $j('#more_platforms').val(); 
	window.location = link_loc;
});

$j('.filter_list a,.filter_alpha a').hover(function() {
		$j(this).addClass('hover');
		},function(){
		$j(this).removeClass('hover')
})

 })
 


